#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from AddOneInstitution import AddOneInstitution

# Create Institutions

def AddInstitutions(VistA,state,stationnumber):
  AddOneInstitution(VistA,state + ' VA HEALTHCARE SYSTEM',stationnumber,    'MC','4529860114','Y','HCS','1 Main ST','Anywhere',state,'14114')
  AddOneInstitution(VistA,state + ' VA MEDICAL CENTER',stationnumber+'MC',  'MC' ,'8890253874','N','VAMC','1 Main ST','Anywhere',state,'14114')
  AddOneInstitution(VistA,state + ' VA OUTPATIENT CLINC',stationnumber+'OC',''   ,'7764091279','N','CBOC','1 Main ST','Anywhere',state,'14114')

def AddInstitutionsByConfig(VistA, institutionsJson):
  for institution in institutionsJson:
    AddOneInstitution(VistA, institution['Name'], institution['Station Number'],
                      institution.get('Type Code',''), institution['NPI'],
                      institution['MultiDivision'], institution['Facility Type'],
                      institution.get('Street',''), institution.get('City',''),
                      institution.get('State',''), institution.get('Zip Code',''))

